<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->

include 'includes/conexao.php';

// Busca só apps sem código (codigo NULL ou vazio)
$stmt = $conexao->prepare("SELECT * FROM apps WHERE codigo IS NULL OR codigo = '' ORDER BY id DESC");
$stmt->execute();
$apps = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<link rel="icon" href="caminho/do/favicon.ico" type="image/x-icon">
<title>Loja de Apps</title>

<style>
    * {
        box-sizing: border-box;
    }
    body {
        margin: 0;
        background-color: #0f0f1a;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #cceeffdd;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        align-items: center;
        padding: 30px 15px;
    }

    h1 {
        color: #00f0ff;
        text-shadow: 0 0 12px #00f0ffbb;
        font-size: 2.5rem;
        margin-bottom: 60px;
        user-select: none;
    }

    .app-grid {
        width: 100%;
        max-width: 1200px;
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 28px;
    }

    @media (max-width: 980px) {
        .app-grid {
            grid-template-columns: repeat(2, 1fr);
        }
    }
    @media (max-width: 600px) {
        .app-grid {
            grid-template-columns: 1fr;
        }
    }

    .app-card {
        background: rgba(15, 15, 26, 0.75);
        border: 2px solid #00f0ff;
        border-radius: 18px;
        padding: 20px;
        backdrop-filter: blur(16px);
        box-shadow: 0 0 25px #00f0ff55;
        display: flex;
        flex-direction: column;
        transition: transform 0.25s ease, box-shadow 0.25s ease;
        cursor: default;
        outline: none;
    }

    .app-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 0 45px #00f0ffcc, 0 0 65px #00f0ffaa;
    }

    .app-card:focus {
        box-shadow: 0 0 45px #00f0ffcc, 0 0 65px #00f0ffaa, 0 0 90px #00f0ffdd;
        transform: translateY(-10px) scale(1.02);
        z-index: 1;
    }

    .app-image {
        width: 100%;
        height: 180px;
        border-radius: 14px;
        overflow: hidden;
        margin-bottom: 20px;
        background: #001622;
        display: flex;
        justify-content: center;
        align-items: center;
        color: #00f0ff66;
        font-size: 1rem;
        user-select: none;
    }

    .app-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 14px;
    }

    .app-info h2 {
        color: #00f0ff;
        margin: 0 0 12px 0;
        font-size: 1.5rem;
        text-shadow: 0 0 12px #00f0ffbb;
    }

    .app-info p {
        flex-grow: 1;
        white-space: pre-wrap;
        line-height: 1.4;
        font-size: 1rem;
        margin-bottom: 30px;
        color: #a0dfffcc;
    }

    .buttons-group {
        display: flex;
        gap: 14px;
        flex-wrap: wrap;
        justify-content: center;
    }

    .neon-button {
        background: transparent;
        border: 2.5px solid #00f0ff;
        color: #00f0ff;
        padding: 12px 20px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 1rem;
        cursor: pointer;
        text-decoration: none;
        user-select: none;
        transition: all 0.3s ease;
        text-align: center;
        display: inline-block;
        flex: 1 1 calc(50% - 14px);
        max-width: calc(50% - 14px);
        box-sizing: border-box;
    }

    .neon-button:hover {
        background: #00f0ff;
        color: #0f0f1a;
        box-shadow: 0 0 20px #00f0ffdd, 0 0 40px #00f0ffaa;
        transform: translateY(-3px);
    }

    .buttons-group.single-button .neon-button {
        flex: 1 1 100%;
        max-width: 100%;
    }

    @media (max-width: 600px) {
        .buttons-group {
            flex-direction: column;
            gap: 16px;
            align-items: stretch;
        }
        .neon-button {
            flex: 1 1 100%;
            max-width: 100%;
        }
    }

    .no-apps {
        text-align: center;
        color: #00f0ffcc;
        font-size: 1.3rem;
        margin-top: 50px;
        user-select: none;
    }

    @keyframes pulse {
        0%, 100% {
            transform: scale(1);
            filter: drop-shadow(0 0 5px #00f0ff);
        }
        50% {
            transform: scale(1.2);
            filter: drop-shadow(0 0 20px #00f0ff);
        }
    }

    h1 span.emoji-pulse {
        display: inline-block;
        animation: pulse 2s infinite ease-in-out;
    }
</style>
</head>
<body>

<h1><span class="emoji-pulse">🛍️</span>️ Nossa Loja de Apps</h1>

<?php if (count($apps) === 0): ?>
    <div class="no-apps">Nenhum app cadastrado disponível no momento.</div>
<?php else: ?>
    <div class="app-grid">
        <?php foreach ($apps as $app): ?>
            <div class="app-card" tabindex="0">
                <div class="app-image">
                    <?php if ($app['imagens'] && file_exists('assets/imagens/' . $app['imagens'])): ?>
                        <img src="<?= 'assets/imagens/' . htmlspecialchars($app['imagens']) ?>" alt="<?= htmlspecialchars($app['nome']) ?>">
                    <?php else: ?>
                        Sem imagem
                    <?php endif; ?>
                </div>
                <div class="app-info">
                    <h2><?= htmlspecialchars($app['nome']) ?></h2>
                    <p><?= nl2br(htmlspecialchars($app['info'])) ?></p>
                </div>
                <div class="buttons-group <?= ((($app['url'] && $app['apk']) ? '' : 'single-button')) ?>">
                    <?php if ($app['url']): ?>
                        <a href="<?= htmlspecialchars($app['url']) ?>" target="_blank" rel="noopener noreferrer" class="neon-button">Visitar</a>
                    <?php endif; ?>
                    <?php if ($app['apk'] && file_exists('assets/apks/' . $app['apk'])): ?>
                        <a href="<?= 'assets/apks/' . htmlspecialchars($app['apk']) ?>" download class="neon-button">Download APK</a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<script>
    // Dá foco automático no primeiro card quando a página carrega
    window.addEventListener('load', () => {
        const cards = document.querySelectorAll('.app-card');
        if (cards.length > 0) {
            cards[0].focus();
        }
    });
</script>

</body>
</html>
