<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->



session_start();
include 'includes/conexao.php';

$nome = $_GET['id'] ?? '';
$nome = trim($nome);

if ($nome === '') {
    $_SESSION['msg_erro'] = "Nome do app inválido.";
    header("Location: visualizar.php");
    exit;
}

$stmt = $conexao->prepare("SELECT * FROM apps WHERE nome = ?");
$stmt->execute([$nome]);
$app = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$app) {
    $_SESSION['msg_erro'] = "App não encontrado.";
    header("Location: visualizar.php");
    exit;
}

$dirApk = __DIR__ . '/assets/apks/';
$dirImg = __DIR__ . '/assets/imagens/';

// Deleta APK
if (!empty($app['apk'])) {
    $apkFile = $dirApk . $app['apk'];
    if (file_exists($apkFile)) {
        unlink($apkFile);
    }
}

// Deleta imagem
if (!empty($app['imagens'])) {
    $imgFile = $dirImg . $app['imagens'];
    if (file_exists($imgFile)) {
        unlink($imgFile);
    }
}

// Deleta registro do banco
$del = $conexao->prepare("DELETE FROM apps WHERE nome = ?");
if ($del->execute([$nome])) {
    $_SESSION['msg_sucesso'] = "App '{$nome}' deletado com sucesso!";
} else {
    $_SESSION['msg_erro'] = "Erro ao deletar app no banco.";
}

// Redireciona para visualizar.php
header("Location: visualizar.php");
exit;
