<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->



session_start();

$apk_dir = __DIR__ . '/assets/apks/';

$id = $_GET['id'] ?? '';
if (!$id) {
    die("App não especificado.");
}

$apk_path = $apk_dir . $id . '.apk';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['editar_apk'])) {
    if (!empty($_FILES['apk']['name'])) {
        $ext = pathinfo($_FILES['apk']['name'], PATHINFO_EXTENSION);
        if (strtolower($ext) !== 'apk') {
            $_SESSION['mensagem'] = "Arquivo deve ser .apk";
        } else {
            $destino = $apk_path;
            if (move_uploaded_file($_FILES['apk']['tmp_name'], $destino)) {
                $_SESSION['mensagem'] = "APK atualizado com sucesso!";
            } else {
                $_SESSION['mensagem'] = "Erro ao enviar APK.";
            }
        }
    } else {
        $_SESSION['mensagem'] = "Nenhum arquivo enviado.";
    }
    // Evita reenvio POST com refresh
    header("Location: editar_app.php?id=" . urlencode($id));
    exit;
}

include 'includes/header.php'; // seu header normal

?>

<style>
/* Estilo modal (container) glass e centralizado */
.modal-container {
    position: fixed;
    top: 0; left: 0; right: 0; bottom: 0;
    background: rgba(10,10,20,0.75);
    backdrop-filter: blur(8px);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    padding: 20px;
}

.modal-content {
    background: rgba(10, 10, 20, 0.85);
    border: 1px solid #00f0ff;
    border-radius: 15px;
    padding: 30px 40px;
    width: 100%;
    max-width: 480px;
    box-shadow: 0 0 30px rgba(0, 240, 255, 0.3);
    color: #e0e0e0;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    position: relative;
}

.neon-title {
    color: #00f0ff;
    text-align: center;
    font-size: 2rem;
    margin-bottom: 30px;
    text-shadow: 0 0 10px rgba(0, 240, 255, 0.7);
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 2px;
    font-family: 'Orbitron', sans-serif;
}

form label {
    font-weight: 700;
    color: #00f0ff;
    text-shadow: 0 0 5px rgba(0, 240, 255, 0.7);
    font-size: 0.95rem;
    display: block;
    margin-bottom: 8px;
}

form input[type="file"] {
    background: rgba(15, 15, 30, 0.9);
    border: 1.5px solid #00f0ff;
    border-radius: 10px;
    padding: 12px 15px;
    color: #c0f9f8;
    font-size: 1rem;
    font-weight: 500;
    box-shadow: inset 0 0 12px rgba(0, 240, 255, 0.25);
    width: 100%;
    margin-bottom: 20px;
}

form button {
    background: rgba(0, 240, 255, 0.3);
    color: #00f0ff;
    border: 1.5px solid #00f0ff;
    padding: 14px 0;
    border-radius: 12px;
    font-weight: 700;
    font-size: 1.1rem;
    cursor: pointer;
    text-transform: uppercase;
    letter-spacing: 1.5px;
    box-shadow: 0 0 20px #00f0ff;
    transition: all 0.3s ease;
    width: 100%;
}

form button:hover {
    background: #00f0ff;
    color: #0a1a1e;
    box-shadow: 0 0 35px #00f0ff, 0 0 60px #00f0ffaa;
}

.apk-link {
    display: block;
    margin-bottom: 20px;
    color: #00f0ff;
    text-align: center;
    font-weight: 600;
    text-decoration: none;
    text-shadow: 0 0 8px #00f0ff;
}

.mensagem {
    background: #00fff744;
    border-radius: 10px;
    color: #004d4d;
    font-weight: 700;
    text-align: center;
    padding: 12px;
    margin-bottom: 20px;
    box-shadow: 0 0 12px #00ffcc88;
}

.close-btn {
    position: absolute;
    top: 10px; right: 15px;
    background: transparent;
    border: none;
    font-size: 1.8rem;
    color: #00f0ff;
    cursor: pointer;
    font-weight: 700;
    text-shadow: 0 0 5px #00f0ff;
}
.close-btn:hover {
    color: #00fff7;
}
</style>

<div class="modal-container" id="modalEditar">
    <div class="modal-content">
        <button class="close-btn" onclick="window.location.href='visualizar.php'">&times;</button>

        <h1 class="neon-title">Editar APK</h1>

        <?php if (!empty($_SESSION['mensagem'])): ?>
            <div class="mensagem"><?= htmlspecialchars($_SESSION['mensagem']) ?></div>
            <?php unset($_SESSION['mensagem']); ?>
        <?php endif; ?>

        <p style="text-align:center;">APK atual:</p>
        <a href="assets/apks/<?= htmlspecialchars($id) ?>.apk" target="_blank" class="apk-link"><?= htmlspecialchars($id) ?>.apk</a>

        <form method="POST" enctype="multipart/form-data">
            <label for="apk">Selecionar novo APK (.apk)</label>
            <input type="file" id="apk" name="apk" accept=".apk" required>

            <button type="submit" name="editar_apk">Atualizar APK</button>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
