<?php


//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->


session_start();
include_once('includes/conexao.php');

if (!is_dir('update')) {
    mkdir('update', 0777, true);
}

$mensagem = $_SESSION['mensagem'] ?? '';
unset($_SESSION['mensagem']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nomeApp = trim($_POST['nome_app']);
    $versao = trim($_POST['versao']);
    $mensagemTexto = trim($_POST['mensagem']);

    if (empty($nomeApp) || empty($versao) || empty($mensagemTexto)) {
        $_SESSION['mensagem'] = '<div class="alert neon-error">Preencha todos os campos.</div>';
    } elseif (!isset($_FILES['apk']) || $_FILES['apk']['error'] !== UPLOAD_ERR_OK) {
        $_SESSION['mensagem'] = '<div class="alert neon-error">Erro ao enviar o arquivo APK.</div>';
    } else {
        $nomeAppSanitizado = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $nomeApp);
        $apkCaminho = 'update/' . $nomeAppSanitizado . '.apk';

        if (move_uploaded_file($_FILES['apk']['tmp_name'], $apkCaminho)) {
            $protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
            $host = $_SERVER['HTTP_HOST'];
            $caminhoBase = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
            $url_apk = $protocolo . $host . $caminhoBase . '/update/' . $nomeAppSanitizado . '.apk';

            $dados = [
                'versao' => $versao,
                'mensagem' => $mensagemTexto,
                'url_apk' => $url_apk
            ];

            file_put_contents('update/versao.json', json_encode($dados, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

            $_SESSION['mensagem'] = '<div class="alert neon-success" id="msg-sucesso">APK e JSON salvos com sucesso!</div>';
        } else {
            $_SESSION['mensagem'] = '<div class="alert neon-error" id="msg-erro">Erro ao salvar o arquivo APK.</div>';
        }
    }
    
    // Redireciona para evitar reenvio do formulário
    header('Location: update.php');
    exit();
}

// Inclui o header após o processamento do POST
include_once('includes/header.php');
?>

<style>
    .glass-container {
        background: rgba(15, 15, 26, 0.7);
        backdrop-filter: blur(12px);
        border: 1px solid #00f0ff;
        border-radius: 15px;
        padding: 30px;
        width: 100%;
        max-width: 600px;
        box-shadow: 0 0 25px rgba(0, 240, 255, 0.2);
        margin: 20px auto;
    }

    .neon-title {
        color: #00f0ff;
        text-align: center;
        font-size: 1.8rem;
        margin-bottom: 25px;
        text-shadow: 0 0 10px rgba(0, 240, 255, 0.7);
    }

    .neon-form {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }

    .input-group {
        width: 100%;
    }

    .input-group label {
        display: block;
        margin-bottom: 8px;
        color: #00f0ff;
        font-size: 0.9rem;
    }

    .input-group input,
    .input-group textarea {
        width: calc(100% - 24px);
        padding: 12px;
        background: rgba(0, 0, 30, 0.5);
        border: 1px solid #00f0ff;
        border-radius: 8px;
        color: white;
        font-size: 1rem;
        transition: all 0.3s;
    }

    .input-group textarea {
        resize: vertical;
        min-height: 100px;
    }

    .input-group input:focus,
    .input-group textarea:focus {
        outline: none;
        border-color: #00b7ff;
        box-shadow: 0 0 10px rgba(0, 183, 255, 0.5);
    }

    .neon-button {
        background: transparent;
        color: #00f0ff;
        border: 2px solid #00f0ff;
        padding: 12px;
        font-size: 1.1rem;
        cursor: pointer;
        border-radius: 8px;
        transition: all 0.3s;
        margin-top: 10px;
        width: 100%;
    }

    .neon-button:hover {
        background: #00f0ff;
        color: #0f0f1a;
        box-shadow: 0 0 20px #00f0ff;
        transform: translateY(-2px);
    }

    .alert {
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        text-align: center;
        width: 100%;
    }

    .neon-success {
        background: rgba(0, 255, 136, 0.1);
        border: 1px solid #00ff88;
        color: #00ff88;
    }

    .neon-error {
        background: rgba(255, 85, 85, 0.1);
        border: 1px solid #ff5555;
        color: #ff5555;
    }
</style>

<div class="glass-container">
    <h2 class="neon-title">Gerar JSON de Atualização</h2>

    <?php if (!empty($mensagem)) echo $mensagem; ?>

    <form method="POST" enctype="multipart/form-data" class="neon-form">
        <div class="input-group">
            <label for="nome_app">Nome do App</label>
            <input type="text" name="nome_app" id="nome_app" required>
        </div>
        <div class="input-group">
            <label for="versao">Versão</label>
            <input type="text" name="versao" id="versao" required>
        </div>
        <div class="input-group">
            <label for="mensagem">Mensagem</label>
            <textarea name="mensagem" id="mensagem" required></textarea>
        </div>
        <div class="input-group">
            <label for="apk">Arquivo APK</label>
            <input type="file" name="apk" id="apk" accept=".apk" required>
        </div>
        <button type="submit" class="neon-button">Salvar JSON</button>
    </form>
</div>

<script>
    setTimeout(() => {
        const alert = document.querySelector('.alert');
        if (alert) {
            alert.style.transition = "opacity 0.5s ease-out";
            alert.style.opacity = '0';
            setTimeout(() => alert.remove(), 500);
        }
    }, 3000);
</script>