<?php


//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->



session_start();
include 'includes/conexao.php';

$mensagem = $_SESSION['mensagem'] ?? '';
unset($_SESSION['mensagem']);
$erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario_atual = trim($_POST['usuario_atual'] ?? '');
    $novo_usuario = trim($_POST['novo_usuario'] ?? '');
    $senha_nova = $_POST['senha_nova'] ?? '';

    if (!$usuario_atual || !$novo_usuario || !$senha_nova) {
        $erro = "Preencha todos os campos: usuário atual, novo usuário e nova senha.";
    } else {
        $busca = $conexao->prepare("SELECT * FROM usuarios WHERE usuario = ?");
        $busca->execute([$usuario_atual]);
        $usuario_existe = $busca->fetch(PDO::FETCH_ASSOC);

        if (!$usuario_existe) {
            $erro = "Usuário atual não encontrado.";
        } else {
            $nova_hash = password_hash($senha_nova, PASSWORD_DEFAULT);
            $atualiza = $conexao->prepare("UPDATE usuarios SET usuario = ?, senha_hash = ? WHERE usuario = ?");
            $atualiza->execute([$novo_usuario, $nova_hash, $usuario_atual]);

            if ($atualiza->rowCount() > 0) {
                $_SESSION['mensagem'] = "Usuário e senha atualizados com sucesso!";
                header("Location: profile.php");
                exit;
            } else {
                $erro = "Erro ao atualizar usuário e senha.";
            }
        }
    }
}

include 'includes/header.php';
?>

<div class="main-content">
    <div class="glass-container">
        <h1 class="neon-title">⚙️ Perfil</h1>

        <?php if ($mensagem): ?>
            <div class="alert neon-success"><?= htmlspecialchars($mensagem) ?></div>
        <?php endif; ?>

        <?php if ($erro): ?>
            <div class="alert neon-error"><?= htmlspecialchars($erro) ?></div>
        <?php endif; ?>

        <form method="POST" class="neon-form">
            <div class="input-group">
                <label>Usuário Atual</label>
                <input type="text" name="usuario_atual" required>
            </div>

            <div class="input-group">
                <label>Novo Usuário</label>
                <input type="text" name="novo_usuario" required>
            </div>

            <div class="input-group">
                <label>Nova Senha</label>
                <input type="password" name="senha_nova" required>
            </div>

            <button type="submit" class="neon-button">Atualizar</button>
        </form>
    </div>
</div>

<style>
    /* Estilo Aprimorado */
    body {
        margin: 0;
        padding: 0;
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        background-color: #0f0f1a;
    }

    .main-content {
        padding: 20px;
        display: flex;
        justify-content: center;
        align-items: center;
        flex: 1;
    }

    .glass-container {
        background: rgba(15, 15, 26, 0.7);
        backdrop-filter: blur(12px);
        border: 1px solid #00f0ff;
        border-radius: 15px;
        padding: 30px;
        width: 100%;
        max-width: 600px;
        box-shadow: 0 0 25px rgba(0, 240, 255, 0.2);
        margin: 20px 0;
    }

    .neon-title {
        color: #00f0ff;
        text-align: center;
        font-size: 1.8rem;
        margin-bottom: 25px;
        text-shadow: 0 0 10px rgba(0, 240, 255, 0.7);
    }

    .neon-form {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }

    .input-group {
        width: 100%;
    }

    .input-group label {
        display: block;
        margin-bottom: 8px;
        color: #00f0ff;
        font-size: 0.9rem;
    }

    .input-group input,
    .input-group textarea,
    .input-group input[type="file"] {
        width: calc(100% - 24px);
        padding: 12px;
        background: rgba(0, 0, 30, 0.5);
        border: 1px solid #00f0ff;
        border-radius: 8px;
        color: white;
        font-size: 1rem;
        transition: all 0.3s;
    }

    .input-group textarea {
        resize: vertical;
        min-height: 100px;
    }

    .input-group input:focus,
    .input-group textarea:focus {
        outline: none;
        border-color: #00b7ff;
        box-shadow: 0 0 10px rgba(0, 183, 255, 0.5);
    }

    .neon-button {
        background: transparent;
        color: #00f0ff;
        border: 2px solid #00f0ff;
        padding: 12px;
        font-size: 1.1rem;
        cursor: pointer;
        border-radius: 8px;
        transition: all 0.3s;
        margin-top: 10px;
        width: 100%;
    }

    .neon-button:hover {
        background: #00f0ff;
        color: #0f0f1a;
        box-shadow: 0 0 20px #00f0ff;
        transform: translateY(-2px);
    }

    .alert {
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        text-align: center;
        width: 100%;
    }

    .neon-success {
        background: rgba(0, 255, 136, 0.1);
        border: 1px solid #00ff88;
        color: #00ff88;
    }

    .neon-error {
        background: rgba(255, 85, 85, 0.1);
        border: 1px solid #ff5555;
        color: #ff5555;
    }
    
    /* Responsividade */
    @media (max-width: 980px) {
        .app-grid {
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        }
    }

    @media (max-width: 600px) {
        .app-grid {
            grid-template-columns: 1fr;
        }
    }
</style>
